/*  Blank version 1.3.1 */
/*  Original version 1.1 was */
/*  written by Andrew Turley */
/*  on 3.16.97 and 3.17.97 */
/*  some commands added by RaV */

/*  Blank should compile using any C compiler, but if you have problems */
/*  or tips please e-mail me */
/* OBSOLETE */
/*  aturley@sound.net */
/* NEW */
/* aturley@bu.edu */
/* unefunge@friko2.onet.pl */

/* Fixes / changes: */
/* 1.4.2 | 28-07-98 | improved debugger */
/*                  | new commands: {s} - system {p} - print_string */
/* 1.4.1 | 27-07-98 | delay in debugger mode */
/* 1.4.0 | 22-07-98 | built-in debugger added */
/*                  | - file commands {=}{_} are now equal to {~}{,} */
/* 1.3.1 | 09-10-97 | bad stack height after {^} command. */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#ifdef __THINK__
	#include <console.h>
#endif
#define 	VERSION "1.4.3rs"
#define		DEBUG_DELAY 1

/*** Declare Structures ***/
struct stack
  {
    signed long val;       /* Value on the stack */
    struct stack *next;    /* Points to next item of stack */
  } *head;                 /* Points to the top of the stack */

struct cell
  {
    signed long content;   /* Content of the particular program cell */
    struct cell *right;    /* Points to right program cell */
    char kind;             /* Tells if DATA or INSTRUCT */
  } *current;              /* Points to the current program cell */

struct prostack
  {
    struct cell *caller;   /* Points to the cell which called the function */
    struct prostack *pnext;/* Points to the next program stack item */
  } *phead;                /* Points to the head of the program stack */

/*** Function Prototypes ***/
void push (signed long val);
signed long pop (void);
void ppush (struct cell *loc);
struct cell *ppop (void);
/*signed long scopy (signed long); */
void scopy (signed long);
void outstack (void);
void pop_string (char *str);
unsigned int sleep(unsigned int);
/*sys_tem(char *str);*/

signed long sh = 0;        /* stack height */
int debug_mode = 0; 

/*** Main Program ***/
int main (int argc, char **argv)
  {
  FILE *z;
  struct cell *start;
  struct cell *s;
  struct cell *ce;
  char cre, t, dat, curc, c, move;
  signed long count, cur, a, b, d,i;
  char str[256];

#ifdef __THINK__
	argc = ccommand(&argv);
#endif

  if (argc == 1) 
    {
    fprintf (stderr, "bl - blank interpreter v.%s\n", VERSION);
    fprintf (stderr, "USAGE: %s [-d |--debug ] source.bl\n", argv[0]);
    fflush (stderr);
    exit(0);
    }
  for(i=1;i<(argc-1);i++)
		{
			if((!strcmp(argv[i], "-d")) || (!strcmp(argv[i], "--debug"))) 
				debug_mode=1;
		}
  if ((z = fopen(argv[argc-1], "r")) != 0)
    {
    count = 0;
    while ((dat = fgetc(z)) != EOF)
      {
      switch (dat)
        {
				case '#':
					{
					if (count == 0)
						{
						while ((dat = fgetc(z)) != '\n')
							;
						}
        	}
        case '~':               /* push char */
          {
          cre = 'y';
          s = (struct cell *) malloc (sizeof (struct cell));
          s->kind = 'd';
          s->content = fgetc (z);
          }
          break;
        case '[':
          {
          cre = 'y';
          s = (struct cell *) malloc (sizeof (struct cell));
          s->kind = 'd';
          s->content = 0;
          while ((dat = fgetc(z)) != ']')
            {
            a = s->content;
            dat = dat - '0';
            a *= 10;
            a += dat;
            s->content = a;
            }
          }
          break;
        case '{':
          {
          cre = 'y';
          s = (struct cell *) malloc (sizeof (struct cell));
          s->kind = 'i';
          while ((dat = fgetc(z)) != '}')
            s->content = dat;
          }
          break;
				default:
					;
        }
      if (cre)                 /* if a new cell has actually been created */
        {
        if (count)             /* if this is not the first cell */
          {
          current->right = s;  /* current -> new */
          count++;             /* increase count */
          }
        current = s;           /* make newly formed cell the current cell */
        if (!count)            /* if this is is the first cell */
          {
          count++;             /* increase count */
          start = s;           /* new cell marked as start */
          }
        cre = 0;
        }
      }
    s->right = start;        /* newly formed cell loops to first cell */
    fclose(z);               /* close the file */
    current = start;         /* make the start cell the current cell */
    } else
    {
    fprintf(stderr,"%s : could not open : %s\n",argv[0], argv[argc-1]);
    exit (0);
    }
  /*** Interpreting Begins Here ***/
  while (((cur = current->content) != '@') || (current->kind == 'd'))
    {
    t = current->kind;
		if (debug_mode == 1)
			{
			if(t=='d')
				{
				fprintf (stderr, "[%ld]",cur);
				}
			else
				{
				fprintf (stderr, "{%c}",(char)cur);
				}
			}
    if (t == 'd')
      {
      push (cur);
      }
    else
      {
      curc = cur;                     /* change integer to char for switch */
      switch (curc)
        {
        case '>':                     /* call */
          ppush (current);            /* put current location on prostack */
          b = pop ();
          for (a = 1; a < b; a++)     /* move right x number of cells */
            current = current->right; /* and make new location current */
          move = 1;
          break;
        case '<':                     /* return */
          s = ppop ();
          if (s)
            current = s;          /* make previous location current */
          break;
        case '+':                     /* add */
          push (pop () + pop ());
          break;
        case '-':                     /* subtract */
          a = pop ();
          b = pop ();
          push (b - a);
          break;
        case '*':
          push (pop () * pop ());     /* multiply */
          break;
        case '/':                     /* divide */
          a = pop ();
          b = pop ();
          push (b / a);
          break;
        case '%':                     /* modulo */
          a = pop ();
          b = pop ();
          push (b % a);
          break;
        case '|':                     /* if */
          d = pop ();
          b = pop ();
          if (d)                 /* if top value of stack > 0 ... */
            {
            ppush (current);          /* put current location on prostack */
            for (a = 1; a < b; a++)     /* move right x number of cells */
              current = current->right; /* and make new location current */
            move = 1;
            }
          break;
        case '$':                     /* pop and discard value */
          pop ();
          break;
        case '~':                     /* get ASCII, put on stack */
          c = fgetc (stdin);
          a = c;                      /* convert char to signed long */
          push (a);
          break;
        case '&':                     /* get number, put on stack */
          fscanf (stdin, "%ld", &a);
          push (a);
          break;
        case ',':                     /* output top stack in ASCII */
          fprintf (stdout,"%c", (char)pop ());
          fflush (stdout);
          break;
        case '.':                     /* output top stack in integer */
          fprintf (stdout, "%ld", pop ());
          fflush (stdout);
          break;
        case '!':                     /* negate top stack */
          if (pop ())
            {
            a = 0;
            } else
            {
            a = 1;
            }
          push (a);
          break;
        case ':':                     /* duplicate top stack */
          a = pop ();
          push (a);
          push (a);
          break;
        case '"':                    /* put value x cells away on stack */
          s = current;
          b = pop ();
          for (a = 0; a < b; a++)
            s = s->right;
          push (s->content);
          break;
        case '\'':                     /* put stack x cells away */
          s = current;
          b = pop ();
          for (a = 0; a < b; a++)
            s = s->right;
          s->content = pop ();
          break;
        case '`':                     /* compare */
          a = pop ();
          b = pop ();
          d = (b > a);
          push (d);
          break;
        case '#':                     /* pop and discard prostack */
          ppop ();
          break;
        case '\\':                    /* swap top two values of stack */
          a = pop ();
          b = pop ();
          push (a);
          push (b);
          break;
        case '=':                     /* input from file to stack*/
					c = fgetc (stdin);
					fflush(stdin);
					a = c;
					push (a);
          break;
        case '_':                     /* output from stack to file */
					a = pop ();
					c = a;
					fprintf (stdout, "%c", (char)c);
					fflush (stdout);
          break;
        /* ver 1.3.x extensions by RaV */ 
        case ';':                     /* output from stack to stderr */
          a = pop ();
          c = a;
          fprintf (stderr, "%c", (char)c);
          fflush (stderr);
          break;
        case 'x':                     /* jump if not EOF */
          b = pop ();
          d = pop ();
          if (d != EOF)
            {
            for (a = 1; a < b; a++)
              current = current->right;
            move = 1;
            push (d);
            }
          break;
        case 'o':                     /* put stack height on stack */
          push (sh);
          break;
        /* end of ver. 1.3.x extensions */
        /* ver 1.4.x extensions */
/* system call not available in Atari version */
/*        case 's': 
          pop_string(str);	
        	systm (str);
        	break;
*/
				case 'p':											/* print stack-stored string */
					pop_string(str);
					fprintf(stdout, str);
					break;
        /* end of ver. 1.4.x extensions */


        case ')':                     /* create a new cell x away */
          s = current;
          b = pop ();
          for (a = 1; a < b; a++)
            s = s->right;
          ce = (struct cell *) malloc (sizeof (struct cell));
          ce->right = s->right;
          s->right = ce;
          ce->kind = 'd';
          ce->content = 0;
          count++;
          break;
        case '(':                     /* destroy cell x away */
          s = current;
          b = pop ();
          for (a = 1; a < b; a++)
            s = s->right;
          ce = s->right;
          s->right = ce->right;
          free (ce);
          count--;
          break;
        case '?':                    /* put program length on stack */
          push (count);
          break;
        case '^':
          scopy (pop ());            /* copies xth stack item to top */
          break;
        }
      }
    if (move == 0);                /* if PC has not moved ... */
      current = current->right;    /* move it to the right */
     	/*
     	if (debug_mode == 1)
     		{
     		if(t=='d')
     			{
					fprintf (stderr, "[%ld]",cur);
					}
     		else
     			{
					fprintf (stderr, "{%c}",(char)cur);
					}
			*/
			if (debug_mode == 1)
     		outstack();
     	/*
     		}
     	*/
    move = 0;
    }
  exit (0);
  }

void push (signed long val)   /* push a value onto the stack */
  {
  struct stack *s;
  s = (struct stack *) malloc (sizeof (struct stack));
  s->val = val;
  s->next = head;
  head = s;
  sh ++;
  }

signed long pop (void)        /* pop a value off of the stack */
  {
  signed long v;
  struct stack *s = head;
  if (s)
    {
    v = head->val;
    head = head->next;
    free (s);
    sh --;
    return (v);
    } else
    {
    return (0);
    }
  }

void ppush (struct cell *loc)  /* push a location onto the stack */
  {
  struct prostack *s;
  s = (struct prostack *) malloc (sizeof (struct prostack));
  s->caller = loc;
  s->pnext = phead;
  phead = s;
  }

struct cell *ppop (void)       /* pop a location off of the stack */
  {
  struct cell *loc;
  struct prostack *s;
  s = phead;
  if (s)
    {
    loc = phead->caller;
    phead = phead->pnext;
    free (s);
    return (loc);
    } else
    {
    return (0);
    }
  }

/*signed long scopy (signed long down)*/   /* copy a value to top of stack */
void scopy (signed long down)   /* copy a value to top of stack */
  {
  signed long a;
  struct stack *s;

  s = head;
  for (a = 1; a < down; a++)
    {
    s = s->next;
    if (s == 0)
      a = down;
    }
  push (s->val);
  }

void outstack (void)
  {
  struct stack *s;
  s = head;
  fprintf (stderr, "\nstack(top-->bottom):\n ");
  fflush (stderr);
  while (s)
    {
    fprintf (stderr,"%10ld", s->val);
    fflush (stderr);
    s = s->next;
    }
  fprintf (stderr,"\n");
  fflush (stderr);
#ifndef M_SCO
  sleep(DEBUG_DELAY);
#endif
  }

void pop_string (char *str)
	{
	int c;
	int i;
	i = 0;
	while ((c = pop()) != 0)
		{
		str[i++] = (char)c;
		}
		str[i] = (char)0;
	}
