/*
   f98ip.h for f98ip.c
   FBBI's Funge-98 Instruction Pointer - header.
   v0.98 Oct 1 1998 Chris Pressey
   Copyunder (u)1998 Cat's-Eye Technologies, http://www.cats-eye.com/
   See http://www.cats-eye.com/license/ for license information.
*/

#ifndef _F98IP_H_
#define _F98IP_H_

typedef struct InstructionPointer
{
  cell ir;      /* instruction register */
  cell x, y;    /* position */
  cell dx, dy;  /* delta */
  cell sx, sy;  /* offset */
  cell a, b;    /* scratch storage */
  cell ec;      /* error code */
  flag sm;      /*-- stringmode */
  flag pm;      /*-- spacemode */
  flag hm;      /*-- haltmode */
  bfspace * bs; /* befunge-space */
  void * s2;   /* stack-stack */
  void (*fingins[26][26])(struct InstructionPointer *);
  int finglev[26]; /* fingerprints */
  int ssize;
  int sssize;
} ip;

extern ip * ip_alloc(bfspace * bs, int ssize, int sssize);
extern void ip_free(ip * i);
extern void ip_reverse(ip * i);
extern void ip_march(ip * i);
extern void ip_backtrack(ip * i);
extern void ip_advance(ip * i);
extern void ip_move(ip * i);

void * ip_stack(ip * i);
cell ip_pop(ip * i);
int ip_push(ip * i, cell x);

int ip_clearstack(ip * i);
cell ip_popoffset(ip * i, int offset);
void ip_pushoffset(ip * i, int offset, cell value);
int ip_allocstack(ip * i);
void ip_freestack(ip * i);
int ip_transfer(ip * i, int val);
void ip_pop_string(ip * i, char * s);
void ip_push_string(ip * i, char * s);
int ip_stack_measure(ip * i);
int ip_stacks_measure(ip * i);
int ip_stack_measure_offset(ip * i, int offset);
cell ip_stack_peek(ip * i, int offset);
cell ip_stack_peek_peek(ip * i, int o1, int o2);

#endif /* _F98IP_H_ not defined */
