/*
   f98stack.h for f98stack.c
   Funge-98 Stack Stack C Functions - header.
   v0.98 Oct 1 1998 Chris Pressey
   Copyunder (u)1998 Cat's-Eye Technologies, http://www.cats-eye.com/
   See http://www.cats-eye.com/license/ for license information.
*/

#ifndef _F98STACK_H_
#define _F98STACK_H_

typedef struct Stack
{
  void * mem;        /* pointer to array of cells of any type */
  long int sp;       /* stack pointer */
  long int sc;       /* total stack capacity */
  long int dc;       /* data capacity of each cell */
} stack;

#ifdef DEBUG_STACK
  #include <stdio.h>
  #ifndef SDEBUG
    #define SDEBUG(x, s) fprintf(stderr, "<-Stack:%s->\n", x);           \
                         fprintf(stderr, "stack pointer: %ld\n", s->sp);  \
                         fprintf(stderr, "stack capacity: %ld\n", s->sc);  \
                         fprintf(stderr, "data capacity: %ld\n", s->dc);    \
                         fflush(stderr);
    #endif
  #else
  #ifndef SDEBUG
    #define SDEBUG(x, s)
    #endif
#endif

/* Given the number of cells (sc) and bytes per cell (dc), */
/* allocate a new stack */
extern stack *      stack_alloc(long int sc, long int dc);

/* Given a pointer to a stack, remove and return the top cell */
extern void *       stack_pop(stack * s);

/* Given a pointer to a stack and a value, place it on the */
/* top of the stack */
extern int          stack_push(stack * s, void * val);

/* Pop a series of cells off the stack as chars until a 0 cell */
extern void         stack_pop_string(stack * s, char * str);

/* Push a series of chars onto the stack as cells until a 0 char */
extern void         stack_push_string(stack * s, char * str);

/* Given a pointer to a stack and a number of cells from the top */
/* cell, return an indexed cell without removing it */
extern void *       stack_read(stack * s, int offset);

/* Return the number of cells on a given stack */
extern int          stack_measure(stack * s);

/* Remove all cells from a given stack */
extern void         stack_clear(stack * s);

/* Release all the memory used by a stack, invalidating the stack */
extern void         stack_free(stack * s);

/* Some handy definitions when working with stacks of stack *'s */

#define stack_stack_top(t)        (stack *)stack_read(t, 0)
#define stack_stack_pop(t)        (stack *)stack_pop(t)
#define stack_stack_push(t,s)     stack_push(t,(void *)s)
#define stack_stack_popcell(t)    stack_pop((stack *)stack_read(t, 0))
#define stack_stack_pushcell(t,s) stack_push((stack *)stack_read(t, 0),(void *)s)
#define stack_stack_popoffset(t,o) stack_pop((stack *)stack_read(t, o))
#define stack_stack_pushoffset(t,o,s) stack_push((stack *)stack_read(t, o),(void *)s)

extern int stack_stack_transfer (stack * t, int count, void * zero);

#endif /* _F98STACK_H_ not defined */
