/*
   fbbi.h for fbbi.c
   Flaming Bovine Befunge Interpreter - header.
   v0.98 Oct 1 1998 Chris Pressey
   Copyunder (u)1998 Cat's-Eye Technologies, http://www.cats-eye.com/
   See http://www.cats-eye.com/license/ for license information.
*/

#ifndef _FBBI_H_
#define _FBBI_H_

/*-- VERSION */

#define FBBI_VERSION_MAJOR  0
#define FBBI_VERSION_MINOR  98

#ifdef _WIN32
  #define FBBI_WIN32
#endif

#ifdef __MSDOS__
  #define FBBI_MSDOS
#endif

#ifdef FBBI_DEBUG
  #define DEBUG(x) fprintf(stderr, "<<%s>>\n", x); fflush(stderr);
  #else
  #define DEBUG(x)
#endif

/*-- TYPE DEFINES */

typedef signed long int cell;
typedef int             flag;

/*-- UTILITY DEFINES */

#define PRINT(x)     (((x >= 32) && (x <= 126)) ? (char)x : '.')
#define GET_a(i)     i->a = ip_pop(i);
#define GET_b(i)     i->b = ip_pop(i);
#define GET_ab(i)    GET_a(i) GET_b(i)
#define DELTA(i,x,y) i->dx = x; i->dy = y;
#define NEG(x)       x = x * -1;

/*-- EXTERNS */

#ifndef FBBI_MINIMAL
extern flag trace;
extern flag warn;
extern flag fast;
extern flag b93;
extern flag une;
#endif

extern char * bargs;
extern char * benv;

#endif /* _FBBI_H_ not defined */

/*-- END OF fbbi.h */
