/*
   fp/ROMA.c for f98fp.c
   Funge-98 Roman Numerals Fingerprint
   v0.98 Oct 1 1998 Chris Pressey
   Copyunder (u)1998 Cat's-Eye Technologies, http://www.cats-eye.com/
   See http://www.cats-eye.com/license/ for license information.
*/

#include <stdio.h>
#include "../fbbi.h"
#include "../bf98spc.h"
#include "../f98stack.h"
#include "../f98ip.h"
#include "../f98i.h"
#include "../f98fp.h"

void fpi_roman(ip * i)
{
  switch (i->ir)
  {
    case 'C': ip_push(i, 100); break;
    case 'D': ip_push(i, 500); break;
    case 'I': ip_push(i, 1); break;
    case 'L': ip_push(i, 50); break;
    case 'M': ip_push(i, 1000); break;
    case 'V': ip_push(i, 5); break;
    case 'X': ip_push(i, 10); break;
    default: ip_reverse(i); break;
  }
}

void semantics_ROMA(ip * i, int load)
{
  if (load)
  {
    overload_semantics(i, 'C', &fpi_roman);
    overload_semantics(i, 'D', &fpi_roman);
    overload_semantics(i, 'I', &fpi_roman);
    overload_semantics(i, 'L', &fpi_roman);
    overload_semantics(i, 'M', &fpi_roman);
    overload_semantics(i, 'V', &fpi_roman);
    overload_semantics(i, 'X', &fpi_roman);
  } else
  {
    restore_semantics(i, 'C');
    restore_semantics(i, 'D');
    restore_semantics(i, 'I');
    restore_semantics(i, 'L');
    restore_semantics(i, 'M');
    restore_semantics(i, 'V');
    restore_semantics(i, 'X');
  }
}

/*-- END OF ROMA.c */
