/*
   fp/index.h for f98fp.c
   Lists fingerprints installed in this build of FBBI.
   v0.98 Oct 1 1998 Chris Pressey
   Copyunder (u)1998 Cat's-Eye Technologies, http://www.cats-eye.com/
   See http://www.cats-eye.com/license/ for license information.

   to add a fingerprint:
   - add 'extern void semantics_zzzz(ip * i, int load);' prototype
   - add '{0xzzzzzzzz, semantics_zzzz},' in flib library[] =
   - compile fp/zzzz.c and recompile FBBI with fp/zzzz.obj

*/

#ifndef FBBI_MINIMAL

extern void semantics_NULL(ip * i, int load);
extern void semantics_ROMA(ip * i, int load);

typedef struct FungeLibrary
{
  cell fingerprint;
  void (*semantics)(ip *, int);
} flib;

flib library[] = 
{
  { 0x524f4d41, semantics_ROMA },
  { 0x4e554c4c, semantics_NULL },
  { 0x00000000, NULL }            /* should always be listed last */
};

#endif
