/** kvik.c
 ** Kvikkalkul Compiler.
 **
 ** Written by and Copyright 1994 Asher Hoskins.
 **
 ** The author retains copyright on this implementation. Permission for
 ** educational and non-profit use is granted to all. If you're planning to
 ** make money with this or any code derived from it, check with the author
 ** first.
 **
 ** Main routine.
 **/

#include <stdio.h>
#include <stdlib.h>
#include "compile.h"

int main(int argc, char *argv[])
{
	FILE *inp, *out;
	char line[MAXLINELENGTH+2];		/* +2 to simplify token matching */
	int linenum = 1;

	if (argc > 1) {
		if ((inp = fopen(argv[1], "r")) == NULL) {
			fprintf(stderr, "kvik: Cannot open '%s'\n", argv[1]);
			exit(1);
		}
		if ((out = fopen("k.out.c", "w")) == NULL) {
			fputs("kvik: Cannot create 'k.out'\n", stderr);
			exit(1);
		}
	}
	else {
		inp = stdin;
		out = stdout;
	}

	start_compile(out, argc, argv);
	while (fgets(line, MAXLINELENGTH, inp) != NULL) {
		compile_line(line, out, linenum);
		linenum++;
	}
	end_compile(out);

	return(0);
}

