/** kvikmath.c
 ** kvik math routines.
 **
 ** Written by and Copyright 1994 Asher Hoskins.
 **
 ** The author retains copyright on this implementation. Permission for
 ** educational and non-profit use is granted to all. If you're planning to
 ** make money with this or any code derived from it, check with the author
 ** first.
 **/

#include "kvikmath.h"

/** Convert string holding fractional part of number to kvik number format.
 **/

kviknum str2kvik(char *n)
{
	int i = 4;
	kviknum k = 0;
	int power = 2000;

	while (i>0 && n[4-i] != '\0') {
		k += (n[4-i] - '0') * power;
		power /= 10;
		i--;
	}

	if (i == 0 && n[4] >= '5')
		k++;

	return(k);
}

/** Negate kvik number.
 **/

kviknum negate(kviknum n)
{
	return(n | 0x8000);
}

/** Convert kvik number to a double.
 **/

double kvik2doub(kviknum n)
{
	int mult = 1;

	if (n & 0x8000) {
		mult = -1;
		n &= 0x7fff;
	}

	return(n/20000.0*mult);
}

/** Convert double to a kvik number.
 **/

kviknum doub2kvik(double n)
{
	kviknum k = 0;

	if (n <= -1 || n >= 1)
		return(OVERFLOW);

	if (n < 0) {
		k = 0x8000;
		n = -n;
	}

/*
	printf("without bodge: %f -> %d\n", n*20000.0, (kviknum)(n*20000.0));
	printf("with bodge: %f -> %d\n", (n*200000.0+1.0)/10.0,
		((kviknum)(n*200000.0+1.0))/10);
*/

	/* The bodgery below is necessary because my elderly version of
	 * gcc is bugged. (e.g. 13578.0 (double) gets converted to 13577 (unsigned
	 * int)). Doing it this way avoids the problem. You may have a problem
	 * if your computer's default int is less than 4 bytes.
	 */
	return(k | ((kviknum)(n*200000.0+1.0))/10);
}

