/****************************************************************
 *  emu_wrap.h
 *			C-Wrapper for module "gbemu"
 *
 *  2000-02-29  Bodo Wenzel  Creation
 *  2000-05-04  Bodo Wenzel  Several emulations in one executable
 *  2000-05-06  Bodo Wenzel  External RAM pageable
 *  2000-06-06  Bodo Wenzel  New memory management
 *  2000-09-09  Bodo Wenzel  Now realy full screen emulation
 *  2000-09-29  Bodo Wenzel  PalmBoy scroller as GB code
 *  2000-10-15  Bodo Wenzel  Interrupts and timer
 *  2000-11-16  Bodo Wenzel  New screen rendering and
 *                           better joypad emulation
 *  2001-01-30  Bodo Wenzel  Support of more cartridges
 ****************************************************************

  (c)2000 Bodo Wenzel

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ****************************************************************/

#ifndef EMU_WRAP_H
#define EMU_WRAP_H

/* === Constants ==============================================	*/

#define  MAX_ROM_BANKS  (256)
#define  MAX_RAM_BANKS  (4)

/* positive values are numbers for breakpoint hit */
#define  ERR_DEBUG    (-1)	/* return values		*/
#define  SINGLE_STEP  (-2)
#define  USER_STOP    (-3)
#define  OPCODE_STOP  (-11)
#define  OP_NOT_IMPL  (-21)
#define  UNKNOWN      (-22)
#define  NO_MEM       (-23)
#define  NO_INP       (-24)
#define  NO_OUT       (-25)
#define  FTR_NOT_IMPL (-26)

#define  FLAG_Z  (0x04)
#define  FLAG_C  (0x10)

#define  OFFSET_XT  (0xd0)

#define  CODE_RESET     (0x00)
/* reserved             (0x01..0x05) */
#define  CODE_SCROLLER  (0x06)
/* reserved             (0x07..0x0f) */

#define  V_LCD_LINE     (0x10)
#define  V_OPCODE_STOP  (0x11)
#define  BP_RTS         (0x12)
#define  CALL_INT       (0x18)
/* reserved             (0x19) */
#define  IO_WR_IE       (0x1a)
#define  INT_CHECK      (0x1b)

#define  V_RAM_ENABLE   (0x20)
#define  V_ROML_SELECT  (0x21)
#define  V_ROMH_SELECT  (0x22)
#define  V_RAM_SELECT   (0x23)
#define  V_MODE_SELECT  (0x24)
#define  V_RAM_RD_EXT   (0x25)
#define  V_RAM_WR_EXT   (0x26)
#define  V_RAM_WR8087   (0x28)
#define  V_RAM_WR888F   (0x29)
#define  V_RAM_WR9097   (0x2a)
#define  V_RAM_WR989B   (0x2b)
#define  V_RAM_WR9C9F   (0x2c)
#define  V_RAM_WR_OAM   (0x2d)

#define  BASE_ROM       (0x30)
#define  BASE_RAM       (0x31)
#define  RAM_RD_EXT_STD (0x32)
#define  RAM_WR_EXT_STD	(0x33)

#define  CPU_STATE      (0x40)
#define  TIMING         (0x41)
#define  INT_VARIABLES  (0x42)
#define  JOYPAD         (0x43)
#define  LCD            (0x44)

#define  V_IO_WR_LCDC   (0x50)
#define  V_IO_RD_STAT   (0x51)
#define  V_IO_WR_STAT   (0x52)
#define  V_IO_WR_SCY    (0x53)
#define  V_IO_WR_SCX    (0x54)
#define  V_IO_WR_LY     (0x55)
#define  V_IO_WR_LYC    (0x56)
#define  V_IO_WR_DMA    (0x57)
#define  V_IO_WR_BGP    (0x58)
#define  V_IO_WR_OBP0   (0x59)
#define  V_IO_WR_OBP1   (0x5a)
#define  V_IO_WR_WY     (0x5b)
#define  V_IO_WR_WX     (0x5c)

/* === Types ==================================================	*/

typedef struct {
  unsigned char  *rom_0;
  unsigned char  *rom_1;
  }  BANKS_ROM;

typedef struct {
  unsigned char  *ram_vid;
  unsigned char  *ram_ext;
  unsigned char  *ram_int;
  unsigned char  *ram_oam;
  unsigned char  *ram_cpu;
  }  BANKS_RAM;

typedef struct {
  unsigned char  *pc_base;
  signed short   pc;
  unsigned char  *sp_base;
  signed short   sp;
  unsigned char  a;
  unsigned char  f;
  unsigned char  b;
  unsigned char  c;
  unsigned char  d;
  unsigned char  e;
  unsigned char  h;
  unsigned char  l;
  unsigned char  a_old;
  }  CPU_REGS;

typedef struct {
  unsigned char   ime;
  unsigned char   ie;
  unsigned char   ifl;
  unsigned char   im;
  }  INT_VARS;

typedef struct {
  unsigned short  cycles;
  unsigned short  div;
  unsigned char   tma;
  unsigned char   dummy;
  unsigned short  tima;
  unsigned short  d_tima;
  unsigned short  d_tima_tab[8];
  }  TIMING_VARS;

typedef struct {
  unsigned char  *ptr;
  unsigned char  both;
  unsigned char  cmd;
  unsigned char  dir;
  unsigned char  none;
  } JOYPAD_VARS;

typedef struct {
  unsigned char  lcdc;
  unsigned char  stat;
  unsigned char  scy;
  unsigned char  scx;
           short i_ly;
  unsigned char  ly;
  unsigned char  lyc;
  unsigned char  dma;
  unsigned char  bgp;
  unsigned char  obp0;
  unsigned char  obp1;
           short i_wy;
  unsigned char  wy;
  unsigned char  wx;
  }  LCD_REGS;

typedef  union {
  unsigned char   gb_code[0x100-sizeof(long)-OFFSET_XT];
  struct {
    unsigned short  jmp;
    void            (*addr)(void);
  }               vector;
  void            *func;
  BANKS_ROM       banks_rom;
  BANKS_RAM       banks_ram;
  CPU_REGS        cpu_regs;
  TIMING_VARS     timing_vars;
  INT_VARS        int_vars;
  JOYPAD_VARS     joypad;
  LCD_REGS        lcd_regs;
}  EMU_EXTENSION;

typedef  struct {
  unsigned char  reserved[OFFSET_XT];
  EMU_EXTENSION  ext;
  long           prof;
}  EMU_COMBO;

#if sizeof(EMU_COMBO) != 0x100
#error "Error(s) in definition of COMBO!"
#endif

/* === Emulations =============================================	*/

extern  EMU_COMBO  emu_pure[];
extern  EMU_COMBO  emu_chk[];
extern  EMU_COMBO  emu_prof[];
extern  EMU_COMBO  emu_step[];

extern  unsigned char  palm_begin[];
extern  unsigned char  palm_end[];

/* === Functions ==============================================	*/

long gbrun(EMU_COMBO *emulation);

/* === End ====================================================	*/

#endif
