;****************************************************************
;*  emu_wrap.s
;*			C-Wrapper for module "gbemu"
;*
;*  2000-02-24  Bodo Wenzel  Creation
;*  2000-06-02  Bodo Wenzel  Correction of opcode 00 profile
;*  2000-06-06  Bodo Wenzel  New memory management
;*  2000-07-20  Bodo Wenzel  Some improvements
;*  2000-10-02  Bodo Wenzel  Interrupts
;*  2001-02-05  Bodo Wenzel  New stack management
;****************************************************************
;
;  (c)2000 Bodo Wenzel
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
;****************************************************************

;================================================================
; This module wraps the actual emulator, because it should be
; a stand alone segment.

;================================================================
;	General constants

	include	"constant.s"

;================================================================
;	Special things

	xdef	gbrun

	xref	gbemu
	xref	sup_globals

;================================================================

	text

;================================================================
;	long gbrun(EMU_COMBO *emulation);

gbrun:
	movem.l	d1-a6,-(sp)	;save all registers

	move.l	a0,a4
	lea	sup_globals,a5	;setup global pointers

	lea	CPU_STATE_PC_B(a4),a3
	move.l	(a3)+,a0
	add.w	(a3)+,a0
	move.l	(a3)+,a1
	add.w	(a3)+,a1
	move.b	(a3)+,d7
	move.b	(a3)+,d6
	swap	d6
	move.b	(a3)+,d5
	swap	d5
	move.b	(a3)+,d5
	move.b	(a3)+,d4
	swap	d4
	move.b	(a3)+,d4
	move.b	(a3)+,d3
	swap	d3
	move.b	(a3)+,d3	;get CPU state

	move.w	CYCLES(a4),d6
	addq.w	#1,d6
	jsr	$0000(a4)	;call emulator
	move.w	d6,CYCLES(a4)

	lea	CPU_STATE_PC_B(a4),a3
	sub.l	(a3)+,a0
	move.w	a0,(a3)+
	addq.w	#6,a3
	move.b	d7,(a3)+
	swap	d6
	move.b	d6,(a3)+
	swap	d5
	move.b	d5,(a3)+
	swap	d5
	move.b	d5,(a3)+
	swap	d4
	move.b	d4,(a3)+
	swap	d4
	move.b	d4,(a3)+
	swap	d3
	move.b	d3,(a3)+
	swap	d3
	move.b	d3,(a3)+	;store CPU state

	lea	$0000+OFFSET_PROF(a4),a3
	tst.l	(a3)
	beq.s	gr_quit
	subq.l	#1,(a3)		;correct profile counter

gr_quit:
	movem.l	(sp)+,d1-a6	;restore all registers
	rts

;================================================================
	end
