;****************************************************************
;*  gbemu_xt.s
;*			Emulation of the Gameboy CPU
;*			(Extensions)
;*
;*  2000-04-29  Bodo Wenzel  Creation
;*  2000-05-06  Bodo Wenzel  External RAM pageable
;*  2000-06-06  Bodo Wenzel  New memory management
;*  2000-09-09  Bodo Wenzel  Now realy full screen emulation
;*  2000-09-27  Bodo Wenzel  DAA implemented
;*  2000-09-29  Bodo Wenzel  PalmBoy-Scroller as GB code
;*  2000-10-22  Bodo Wenzel  Interrupts and timer
;*  2000-11-16  Bodo Wenzel  New screen rendering and
;*                           better joypad emulation
;*  2000-12-02  Bodo Wenzel  HALT with DI support
;*  2001-01-30  Bodo Wenzel  Support of more cartridges
;*  2001-02-04  Bodo Wenzel  New stack management
;****************************************************************
;
;  (c)2000 Bodo Wenzel
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
;****************************************************************

macro	xtvoid	num
macro	xt&num			;unused extension
	endm
	endm

;================================================================
;	GB code for initializing like the original

macro	xt$0	;set all I/O registers (part 1)
	dc.b	$3e,$ff,$e0,$00	;ld a,$ff ! ld $ff00,a ; P1
	dc.b	$3e,$00,$e0,$05	;ld a,$00 ! ld $ff05,a ; TIMA
	dc.b	$3e,$00,$e0,$06	;ld a,$00 ! ld $ff06,a ; TMA
	dc.b	$3e,$00,$e0,$07	;ld a,$00 ! ld $ff07,a ; TAC
	dc.b	$3e,$80,$e0,$10	;ld a,$80 ! ld $ff10,a ; NR10
	dc.b	$3e,$bf,$e0,$11	;ld a,$bf ! ld $ff11,a ; NR11
	dc.b	$3e,$f3,$e0,$12	;ld a,$f3 ! ld $ff12,a ; NR12
	dc.b	$3e,$bf,$e0,$14	;ld a,$bf ! ld $ff14,a ; NR14
	dc.b	$3e,$3f,$e0,$16	;ld a,$3f ! ld $ff16,a ; NR21
	dc.b	$3e,$00,$e0,$17	;ld a,$00 ! ld $ff17,a ; NR22
	dc.b	$c3,$00,$01	;jp $0100
	endm

macro	xt$1	;set all I/O registers (part 2)
	dc.b	$3e,$bf,$e0,$19	;ld a,$bf ! ld $ff19,a ; NR24
	dc.b	$3e,$7f,$e0,$1a	;ld a,$7f ! ld $ff1a,a ; NR30
	dc.b	$3e,$ff,$e0,$1b	;ld a,$ff ! ld $ff1b,a ; NR31
	dc.b	$3e,$9f,$e0,$1c	;ld a,$9f ! ld $ff1c,a ; NR32
	dc.b	$3e,$bf,$e0,$1e	;ld a,$bf ! ld $ff1e,a ; NR33
	dc.b	$3e,$ff,$e0,$20	;ld a,$ff ! ld $ff20,a ; NR41
	dc.b	$3e,$00,$e0,$21	;ld a,$00 ! ld $ff21,a ; NR42
	dc.b	$3e,$00,$e0,$22	;ld a,$00 ! ld $ff22,a ; NR43
	dc.b	$3e,$bf,$e0,$23	;ld a,$bf ! ld $ff23,a ; NR44
	dc.b	$3e,$77,$e0,$24	;ld a,$77 ! ld $ff24,a ; NR50
	dc.b	$c3,$00,$02	;jp $0200
	endm

macro	xt$2	;set all I/O registers (part 3)
	dc.b	$3e,$f3,$e0,$25	;ld a,$f3 ! ld $ff25,a ; NR51
	dc.b	$3e,$f1,$e0,$26	;ld a,$f1 ! ld $ff26,a ; NR52
	dc.b	$3e,$00,$e0,$40	;ld a,$00 ! ld $ff40,a ; LCDC
	dc.b	$3e,$00,$e0,$41	;ld a,$00 ! ld $ff41,a ; STAT
	dc.b	$3e,$00,$e0,$42	;ld a,$00 ! ld $ff42,a ; SCY
	dc.b	$3e,$00,$e0,$43	;ld a,$00 ! ld $ff43,a ; SCX
	dc.b	$3e,$00,$e0,$45	;ld a,$00 ! ld $ff45,a ; LYC
	dc.b	$3e,$fc,$e0,$47	;ld a,$fc ! ld $ff47,a ; BGP
	dc.b	$3e,$ff,$e0,$48	;ld a,$ff ! ld $ff48,a ; OBP0
	dc.b	$3e,$ff,$e0,$49	;ld a,$ff ! ld $ff49,a ; OBP1
	dc.b	$c3,$00,$03	;jp $0300
	endm

macro	xt$3	;set all I/O registers (part 4)
	dc.b	$3e,$00,$e0,$4a	;ld a,$00 ! ld $ff4a,a ; WY
	dc.b	$3e,$00,$e0,$4b	;ld a,$00 ! ld $ff4b,a ; WX
	dc.b	$3e,$91,$e0,$40	;ld a,$91 ! ld $ff40,a ; LCDC
	dc.b	$3e,$00,$e0,$ff	;ld a,$00 ! ld $ffff,a ; IE
	dc.b	$c3,$00,$04	;jp	$0400
	endm

macro	xt$4	;set up tile map
	dc.b	$21,$00,$98	;ld	hl,$9800
	dc.b	$af		;xor	a
	dc.b	$22		;ld	(hli),a
	dc.b	$7c		;ld	a,h
	dc.b	$fe,$a0		;cp	$a0
	dc.b	$20,$f9		;jr	nz,$0403
	dc.b	$c3,$00,$05	;jp	$0500
	endm

macro	xt$5	;set CPU registers to compatible values
	dc.b	$01,$13,$00	;ld	bc,$0013
	dc.b	$11,$d8,$00	;ld	de,$00d8
	dc.b	$21,$4d,$01	;ld	hl,$014d
	dc.b	$31,$fe,$ff	;ld	sp,$fffe
	dc.b	$3e,$03		;ld	a,$03
	dc.b	$cb,$3f		;srl	a	;af=$01b0
	dc.b	$db		;(illegal for stop)
	endm

;================================================================
;	GB code for scrolling of PalmBoy logo

macro	xt$6	;set up tile table
	dc.b	$3e,$50		;ld	a,144/2+8
	dc.b	$e0,$42		;ld	(SCY),a
	dc.b	$31,$fe,$ff	;ld	sp,$fffe
	dc.b	$21,$00,$81	;ld	hl,$8100
	dc.b	$11,$00,$0b	;ld	de,$0b00
	dc.b	$cd,$00,$09	;call	$0900
	dc.b	$11,$00,$0c	;ld	de,$0c00
	dc.b	$cd,$00,$09	;call	$0900
	dc.b	$11,$00,$0d	;ld	de,$0d00
	dc.b	$cd,$00,$09	;call	$0900
	dc.b	$11,$00,$0e	;ld	de,$0e00
	dc.b	$cd,$00,$09	;call	$0900
	dc.b	$c3,$00,$07	;jp	$0700
	endm

macro	xt$7	;set up tile map
	dc.b	$11,$00,$0f	;ld	de,$0f00
	dc.b	$cd,$00,$09	;call	$0900
	dc.b	$3e,$10		;ld	a,$10
	dc.b	$21,$04,$99	;ld	hl,$9800+8*32+10
	dc.b	$06,$0c		;ld	b,12
	dc.b	$22		;ld	(hli),a
	dc.b	$3c		;inc	a
	dc.b	$05		;dec	b
	dc.b	$20,$fb		;jr	nz,$0707
	dc.b	$21,$24,$99	;ld	hl,$9800+9*32+10
	dc.b	$06,$0c		;ld	b,12
	dc.b	$22		;ld	(hli),a
	dc.b	$3c		;inc	a
	dc.b	$05		;dec	b
	dc.b	$20,$fb		;jr	nz,$0711
	dc.b	$21,$10,$99	;ld	hl,$9800+8*32+22
	dc.b	$77		;ld	(hl),a
	dc.b	$c3,$00,$08	;jp	$0800
	endm

macro	xt$8	;scroll background
	dc.b	$06,$4f		;ld	b,144/2+8-1
	dc.b	$21,$42,$ff	;ld	hl,SCY
	dc.b	$f0,$44		;ldh	a,LY
	dc.b	$fe,$90		;cp	144
	dc.b	$28,$fa		;jr	z,$0805
	dc.b	$f0,$44		;ldh	a,LY
	dc.b	$fe,$90		;cp	144
	dc.b	$20,$fa		;jr	nz,$080b
	dc.b	$70		;ld	(hl),b
	dc.b	$05		;dec	b
	dc.b	$20,$f0		;jr	nz,$0805
	dc.b	$c3,$00,$0a	;jp	$0a00
	endm

macro	xt$9	;copy subroutine for tile table
	dc.b	$06,$28		;ld	b,40
	dc.b	$1a		;ld	a,(de)
	dc.b	$13		;inc	de
	dc.b	$22		;ldi	(hl),a
	dc.b	$22		;ldi	(hl),a
	dc.b	$05		;dec	b
	dc.b	$20,$f9		;jr	nz,$0902
	dc.b	$c9		;ret
	endm

macro	xt$a	;set CPU registers to compatible values
	dc.b	$01,$13,$00	;ld	bc,$0013
	dc.b	$11,$d8,$00	;ld	de,$00d8
	dc.b	$21,$4d,$01	;ld	hl,$014d
	dc.b	$3e,$03		;ld	a,$03
	dc.b	$cb,$3f		;srl	a	;af=$01b0
	dc.b	$db		;(illegal for stop)
	endm

macro	xt$b
	dc.b	$1f,$1f,$19,$18,$30,$31,$3f,$3e
	dc.b	$01,$81,$c3,$c3,$c3,$c7,$86,$0e
	dc.b	$80,$80,$80,$c0,$c0,$c0,$c0,$60
	dc.b	$60,$60,$60,$60,$c0,$c0,$c0,$c0
	dc.b	$0c,$0c,$1e,$1e,$1e,$36,$33,$33
	endm

macro	xt$c
	dc.b	$01,$01,$03,$03,$07,$06,$0e,$0c
	dc.b	$80,$80,$80,$80,$c0,$c0,$c0,$c0
	dc.b	$3e,$3f,$33,$31,$61,$63,$7f,$7e
	dc.b	$00,$01,$83,$86,$8c,$8c,$18,$18
	dc.b	$70,$fc,$8e,$07,$03,$01,$01,$01
	endm

macro	xt$d
	dc.b	$e0,$60,$70,$30,$39,$9f,$9f,$8e
	dc.b	$1c,$38,$71,$e1,$c1,$81,$00,$00
	dc.b	$60,$60,$60,$60,$c0,$c0,$c0,$c0
	dc.b	$0c,$0c,$1f,$1f,$30,$30,$60,$60
	dc.b	$61,$61,$e1,$e1,$73,$33,$33,$33
	endm

macro	xt$e
	dc.b	$80,$80,$80,$80,$00,$00,$f9,$f9
	dc.b	$63,$61,$61,$c1,$c1,$c0,$80,$80
	dc.b	$1c,$98,$b8,$b0,$f0,$e0,$e0,$c0
	dc.b	$60,$60,$60,$60,$31,$31,$31,$31
	dc.b	$c7,$c3,$c1,$c1,$81,$87,$fe,$fc
	endm

macro	xt$f
	dc.b	$18,$98,$98,$8c,$8e,$07,$03,$00
	dc.b	$01,$01,$03,$03,$06,$1c,$f8,$e0
	dc.b	$8e,$8e,$0c,$0c,$1c,$18,$18,$18
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$7c,$82,$7d,$11,$39,$11,$82,$7c
	endm

;================================================================
;	Support and interrupt functions

macro	xt$10			;support for LCD line
	jmp	0.l
	endm

macro	xt$11			;stop opcode
	jmp	0.l
	endm

macro	xt$12			;return after executed breakpoint
	addq.w	#4,sp		;ignore return to emulation
	if	DEBUG & DEBUG_STEP
	return	SINGLE_STEP
	else
	return	0
	endif
	endm

i	set	$13
	rept	$18-i
	xtvoid	$(i)
i	set	i+1
	endm

macro	xt$18			;call interrupt (part 1)
	local	start
start:	do_push	a0
	bra.w	start+$100
	endm

macro	xt$19			;call interrupt (part 2)
	moveq	#0,d0
	move.b	d0,INT_IME(a4)
	move.b	d0,INT_IM(a4)
	move.l	BASE_ROM_0(a4),a0
	move.l	a0,CPU_STATE_PC_B(a4)
	add.w	d1,a0
	next_pc
	endm

macro	xt$1a			;write to IE
	move.l	BASE_RAM_CPU(a4),a2
	move.b	d0,$ffff(a2)
	move.b	d0,INT_IE(a4)
	and.b	INT_IME(a4),d0
	move.b	d0,INT_IM(a4)
	pea	(a6)
	jmp	INT_CHECK(a4)
	endm

macro	xt$1b			;check for pending interrupts
	local	go_on,loop,jump
	move.b	INT_IF(a4),d0
	and.b	INT_IM(a4),d0
	bne.s	go_on
	rts
go_on:	moveq	#$0060,d1
	moveq	#4,d2
loop:	btst	d2,d0
	bne.s	jump
	subq.w	#$0008,d1
	dbra	d2,loop
	rts
jump:	bclr	d2,INT_IF(a4)
	addq.w	#4,sp
	jmp	CALL_INT(a4)
	endm

i	set	$1c
	rept	$20-i
	xtvoid	$(i)
i	set	i+1
	endm

;================================================================
;	Jumps to memory functions

macro	xt$20			;ram enable
	jmp	0.l
	endm

macro	xt$21			;rom bank (low) selection
	jmp	0.l
	endm

macro	xt$22			;rom bank (high) selection
	jmp	0.l
	endm

macro	xt$23			;ram bank selection
	jmp	0.l
	endm

macro	xt$24			;rom/ram mode selection
	jmp	0.l
	endm

macro	xt$25			;read from external $a000..$bfff
	jmp	0.l
	endm

macro	xt$26			;write to external $a000..$bfff
	jmp	0.l
	endm

i	set	$27
	rept	$28-i
	xtvoid	$(i)
i	set	i+1
	endm

macro	xt$28			;write to tile tab $8000..$87ff
	jmp	0.l
	endm

macro	xt$29			;write to tile tab $8800..$8fff
	jmp	0.l
	endm

macro	xt$2a			;write to tile tab $9000..$97ff
	jmp	0.l
	endm

macro	xt$2b			;write to screen $9800..$9bff
	jmp	0.l
	endm

macro	xt$2c			;write to screen $9c00..$9fff
	jmp	0.l
	endm

macro	xt$2d			;write to OAM $fe00..$feff
	jmp	0.l
	endm

i	set	$2e
	rept	$30-i
	xtvoid	$(i)
i	set	i+1
	endm

;================================================================
;	Pointer to memories and standard routines

macro	xt$30			;actual ROM banks
	dc.l	0		;bank 0 $0000..$3fff
	dc.l	1		;bank 1 $4000..$7fff
	endm

macro	xt$31			;actual RAM banks
	dc.l	0		;video RAM $8000..$9fff
	dc.l	0		;external RAM $a000..$bfff
	dc.l	0		;internal RAM $c000..$dfff
	;and			;internal RAM mirror $e000..$fdff
	dc.l	0		;OAM RAM $fe00..$fe9f ($feff)
	dc.l	0		;CPU RAM $ff80..$fffe
	endm

macro	xt$32			;external ram read, standard
	move.l	BASE_RAM_EXT(a4),a2
	lea	(a2,d1.w),a3
	jmp	(a6)
	endm

macro	xt$33			;external ram write, standard
	move.l	BASE_RAM_EXT(a4),a2
	move.b	d0,(a2,d1.w)
	jmp	(a6)
	endm

macro	xt$34			;sp push correction
	movem.l	d0-d2/a2-a3,-(sp)
	move.b	CPU_STATE_SP+1(a4),d1
	subq.b	#1,CPU_STATE_SP+0(a4)
	mem_rd	CPU_STATE_SP+0(a4)
	move.l	a2,CPU_STATE_SP_B(a4)
	lea	2(a3),a1
	movem.l	(sp)+,d0-d2/a2-a3
	rts
	endm

macro	xt$35			;sp pop correction
	movem.l	d0-d2/a2-a3,-(sp)
	move.b	CPU_STATE_SP+1(a4),d1
	addq.b	#1,CPU_STATE_SP+0(a4)
	mem_rd	CPU_STATE_SP+0(a4)
	move.l	a2,CPU_STATE_SP_B(a4)
	move.l	a3,a1
	movem.l	(sp)+,d0-d2/a2-a3
	rts
	endm

macro	xt$36			;sp rom bank correction
	local	go_on
	move.w	CPU_STATE_SP(a4),d1
	bmi.s	go_on
	cmp.w	#$4000,d1
	bcs.s	go_on
	move.l	BASE_ROM_1(a4),a1
	move.l	a1,CPU_STATE_SP_B(a4)
	add.w	d1,a1
go_on:	jmp	(a6)
	endm

macro	xt$37			;sp ram bank correction
	local	go_on
	move.w	CPU_STATE_SP(a4),d1
	cmp.w	#$c000,d1
	bcc.s	go_on
	cmp.w	#$a000,d1
	bcs.s	go_on
	move.l	BASE_RAM_EXT(a4),a1
	move.l	a1,CPU_STATE_SP_B(a4)
	add.w	d1,a1
go_on:	jmp	(a6)
	endm

i	set	$38
	rept	$40-i
	xtvoid	$(i)
i	set	i+1
	endm

;================================================================
;	Variables

macro	xt$40			;CPU state
	dc.l	0		;68000 base memory pointer (pc)
	dc.w	0		;pc
	dc.l	0		;68000 base memory pointer (sp)
	dc.w	0		;sp
	dc.b	0		;a
	dc.b	0		;f
	dc.b	0		;b
	dc.b	0		;c
	dc.b	0		;d
	dc.b	0		;e
	dc.b	0		;h
	dc.b	0		;l
	dc.b	0		;a (old for DAA)
	endm

macro	xt$41			;timing variables
	local	d_tima_tab
	dc.w	0		;opcodes until next lcd line
	dc.w	0		;DIV (bit 15..8)
	dc.b	0		;TMA
	dc.b	0		;unused
	dc.w	0		;TIMA (bit 15..8)
	dc.w	0		;Delta-TIMA
	and.w	#7,d0		;set delta value
	add.w	d0,d0
	lea	d_tima_tab(pc),a3
	move.w	(a3,d0.w),T_D_TIMA(a4)
	jmp	(a6)
d_tima_tab:
	dc.w	0,0,0,0		;timer stopped
	dc.w	114,7296	;timer running
	dc.w	1824,456
	endm

macro	xt$42			;interrupt variables
	dc.b	0		;interrupt master enable
	dc.b	0		;interrupt enable bits
	dc.b	0		;interrupt flag bits
	endm

macro	xt$43			;joypad variables
	dc.l	0		;pointer to one of next
	dc.b	0		;both values to be read
	dc.b	0		;control value to be read
	dc.b	0		;cursor value to be read
	dc.b	$ff		;"none" value to be read
	endm

macro	xt$44			;LCD registers
	dc.b	0		;LCDC control
	dc.b	0		;STAT status and interrupt mode
	dc.b	0		;SCY y coordinate for background
	dc.b	0		;SCX x coordinate for background
	dc.w	0		;I_LY (internal form of LY)
	dc.b	0		;LY  y coordinate (follows I_LY!)
	dc.b	0		;LYC y coordinate for compare
	dc.b	0	;unused	;(DMA dma address high byte)
	dc.b	0		;BGP palette background
	dc.b	0		;OBP0 palette 0 objects
	dc.b	0		;OBP1 palette 1 objects
	dc.w	0		;I_WY (internal form of WY)
	dc.b	0		;WY y coordinate for window
	dc.b	0		;WX x coordinate for window
	endm

i	set	$45
	rept	$50-i
	xtvoid	$(i)
i	set	i+1
	endm

;================================================================
;	Jumps to LCD register functions

macro	xt$50			;write to LCDC
	jmp	0.l
	endm

macro	xt$51			;read from STAT
	jmp	0.l
	endm

macro	xt$52			;write to STAT
	jmp	0.l
	endm

macro	xt$53			;write to SCY
	jmp	0.l
	endm

macro	xt$54			;write to SCX
	jmp	0.l
	endm

macro	xt$55			;write to LY (unused)
	jmp	0.l
	endm

macro	xt$56			;write to LYC
	jmp	0.l
	endm

macro	xt$57			;write to DMA
	jmp	0.l
	endm

macro	xt$58			;write to BGP
	jmp	0.l
	endm

macro	xt$59			;write to OBP0
	jmp	0.l
	endm

macro	xt$5a			;write to OBP1
	jmp	0.l
	endm

macro	xt$5b			;write to WY
	jmp	0.l
	endm

macro	xt$5c			;write to WX
	jmp	0.l
	endm

i	set	$5d
	rept	$70-i
	xtvoid	$(i)
i	set	i+1
	endm

;================================================================

i	set	$70
	rept	$7f-i
	xtvoid	$(i)
i	set	i+1
	endm

macro	xt$7f			;must be empty for Palm
	endm

i	set	$80
	rept	$80
	xtvoid	$(i)		;space for a hidden game ;-)
i	set	i+1
	endm

;================================================================
;	end of include
