/****************************************************************
 *  support.h
 *			Support functions on Atari ST
 *
 *  2000-02-29  Bodo Wenzel  Creation
 *  2000-04-27  Bodo Wenzel  Several emulations in one executable
 *  2000-05-06  Bodo Wenzel  External RAM pageable
 *  2000-09-09  Bodo Wenzel  Now nearly full screen emulation
 *  2000-10-02  Bodo Wenzel  Interrupts
 *  2000-11-18  Bodo Wenzel  New screen rendering
 *  2001-02-18  Bodo Wenzel  Support of more cartridges
 ****************************************************************

  (c)2000 Bodo Wenzel

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ****************************************************************/

#ifndef SUPPORT_H
#define SUPPORT_H

/* === Functions ==============================================	*/

void my_vsync(void);
void my_joyvec(unsigned char *p);

void opcode_stop(void);

void mbc_dummy(void);
void mbc1_rom_select(void);
void mbc1_roml_select(void);
void mbc1_romh_select(void);
void mbc1_ram_select(void);
void mbc1_mode_select(void);
extern int mbc1_rom_lsb;
extern int mbc1_rom_msb;
void mbc2_rom_select(void);
void mbc3_rom_select(void);
void mbc3_ram_select(void);
void mbc3_rtc_latch(void);
void mbc5_rom_select(void);
void mbc5_ram_select(void);

void ram_none(void);

void io_wr_lcdc(void);
void io_rd_stat(void);
void io_wr_stat(void);
void io_wr_scy(void);
void io_wr_scx(void);
void io_wr_lyc(void);
void io_wr_dma(void);
void io_wr_bgp(void);
void io_wr_obp0(void);
void io_wr_obp1(void);
void io_wr_wy(void);
void io_wr_wx(void);

/* === End ====================================================	*/

#endif
