/****************************************************************
 *  win_prof.h
 *			Window handling for profiling output
 *
 *  2000-04-28  Bodo Wenzel  Creation
 ****************************************************************

  (c)2000 Bodo Wenzel

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ****************************************************************/

#ifndef WIN_PROF_H
#define WIN_PROF_H

#include "emu_wrap.h"

/* === Functions ==============================================	*/

int prf_open(EMU_COMBO *emulation);
void prf_close(int handle);

void prf_redraw(int handle,int rx,int ry,int rw,int rh);
void prf_sized(int handle,int x,int y,int w,int h);
void prf_fulled(int handle);
void prf_moved(int handle,int x,int y,int w,int h);
void prf_vslided(int handle,int pos);
void prf_hslided(int handle,int pos);
void prf_arrowed(int handle,int arrow);

void prf_update(int handle,EMU_COMBO *emulation,int clear);

/* === End ====================================================	*/

#endif
