/****************************************************************
 *  win_scr.c
 *			Window handling for GB screen
 *
 *  2000-03-07  Bodo Wenzel  Creation in test
 *  2000-04-26  Bodo Wenzel  Copied to full version
 *  2000-09-10  Bodo Wenzel  Now nearly full screen emulation
 *  2001-01-17  Bodo Wenzel  Support for color screens (SLOW!)
 ****************************************************************

  (c)2000 Bodo Wenzel

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ****************************************************************/

/* === Includes ===============================================	*/

#include <stddef.h>
#include <stdlib.h>
#include <aes.h>
#include <vdi.h>
#include <linea.h>
#include <tos.h>

#include "win_scr.h"
#include "stemboy.h"
#include "gem_add.h"
#include "support.h"

/* === Constants ==============================================	*/

#define  SCR_WIDTH   (160)
#define  SCR_HEIGHT  (144)

#define  KIND  (NAME|MOVER|INFO)

/* === Prototypes =============================================	*/

/* === Variables ==============================================	*/

void  *scr_imgs[]={NULL,NULL,NULL,NULL};
void  **scr_img=scr_imgs;
char  *scr_base;
int   scr_bpl,scr_double;

static  int  vdi_color[4][3];

static  MFDB  img_mfdb={NULL,SCR_WIDTH,SCR_HEIGHT,
                        SCR_WIDTH/16};
static  int   trn_pxy[8]={0,0,SCR_WIDTH-1,SCR_HEIGHT-1,
                          0,0,SCR_WIDTH-1,SCR_HEIGHT-1};
static  MFDB  trn_mfdb[2]={
                {NULL,SCR_WIDTH,SCR_HEIGHT,SCR_WIDTH/16,1,1},
                {NULL,SCR_WIDTH,SCR_HEIGHT,SCR_WIDTH/16,1,1}};
static  void  *trn_data=NULL;
static  int   trn_col[3];
static  int   scr_pxy[8]={0,0,SCR_WIDTH-1,SCR_HEIGHT-1};
static  MFDB  scr_mfdb={NULL};

#define  NVBLS      (*((short *)0x454))
#define  _VBLQUEUE  (*((void ***)0x456))

static  void  **vbl_slot=NULL;
static  void  *old_vsync=NULL;

/* === Functions ==============================================	*/

int scr_open(void) {
  /*--------------*/
  int     x,y,w,h,handle,n;
  BITBLK  *bitblk;
  int     work_out[57];
  char    *s,*img,*scr;
  int     col[3];
  void    *usp;
  void    **p;

  wind_get(0,WF_WORKXYWH,&x,&y,&w,&h);
  wind_calc(WC_WORK,KIND,x,y,w,h,&x,&y,&w,&h);
  x=((x/8+1)/2)*16;
  if (w<SCR_WIDTH || h<SCR_HEIGHT)
    return -1;			/* screen to small */

  scr_pxy[4]=x;
  scr_pxy[5]=y;
  scr_pxy[6]=x+SCR_WIDTH-1;
  scr_pxy[7]=y+SCR_HEIGHT-1;
  rsrc_gaddr(R_IMAGEDATA,ILTGRAY,&bitblk);
  if (bitblk->bi_wb!=SCR_WIDTH/8 || bitblk->bi_hl!=SCR_HEIGHT ||
      bitblk->bi_x!=0 || bitblk->bi_y!=0)
    return -2;			/* wrong image data */
  trn_mfdb[0].fd_addr=bitblk->bi_pdata;
  scr_img[0]=bitblk->bi_pdata;
  rsrc_gaddr(R_IMAGEDATA,IDKGRAY,&bitblk);
  if (bitblk->bi_wb!=SCR_WIDTH/8 || bitblk->bi_hl!=SCR_HEIGHT ||
      bitblk->bi_x!=0 || bitblk->bi_y!=0)
    return -2;			/* wrong image data */
  trn_mfdb[1].fd_addr=bitblk->bi_pdata;
  scr_img[1]=bitblk->bi_pdata;
  scr_img[2]=scr_img[1];
  scr_img[3]=NULL;

  wind_calc(WC_BORDER,KIND,x,y,SCR_WIDTH,SCR_HEIGHT,&x,&y,&w,&h);
  if ((handle=wind_create(KIND,x,y,w,h))<0)
    return -3;			/* can't create window */

  rsrc_gaddr(R_STRING,SSCRTITL,&s);
  wind_set(handle,WF_NAME,s);
  rsrc_gaddr(R_STRING,SSCRSTOP,&s);
  wind_set(handle,WF_INFO,s);
  graf_growbox(0,0,0,0,x,y,w,h);
  wind_open(handle,x,y,w,h);

  wind_set(handle,WF_TOP);
  wind_get(handle,WF_TOP,&x);
  if (x!=handle) {
    scr_close(handle);
    return -4;			/* can't top window */
  }

  vq_extnd(vdi_handle,1,work_out);
  if (work_out[4]==1) {		/* monochrome, tricky case */
    scr_double=1;

    img_mfdb.fd_addr=scr_img[0];
    img_mfdb.fd_stand=1;
    img_mfdb.fd_nplanes=1;

    linea_init();
    scr_bpl=Vdiesc->bytes_lin;
    col[0]=1;
    col[1]=0;
    vs_clip(vdi_handle,1,scr_pxy+4);
    vrt_cpyfm(vdi_handle,MD_REPLACE,scr_pxy,
              &img_mfdb,&scr_mfdb,col);
    img=scr_img[0];
    scr_base=(char*)Logbase()+scr_pxy[5]*scr_bpl+scr_pxy[4]/8;
    scr=scr_base;
    for (y=0; y<SCR_HEIGHT; y++, scr+=scr_bpl-SCR_WIDTH/8)
      for (x=0; x<SCR_WIDTH/8; x++, img++, scr++)
        if (*img!=*scr) {
          scr_close(handle);
          return -5;		/* can't access directly */
        }

    usp=(void*)Super(0);
    n=NVBLS;
    p=_VBLQUEUE;
    for (; n--; p++)
      if (*p==NULL) {
        vbl_slot=p;
        break;
      }
    Super(usp);

    if (vbl_slot==NULL) {
      scr_close(handle);
      return -6;		/* can't install vbl handler */
    }

  } else {			/* color, yeah! */
    scr_double=-1;

    if (work_out[4]==2) {
      trn_col[0]=2;
      trn_col[2]=3;
    } else if (work_out[4]==3) {
      scr_close(handle);
      return -7;		/* don't know this screen */
    } else {
      trn_col[0]=LWHITE;
      trn_col[2]=LBLACK;
    }
    trn_col[1]=0;
	/* the following block switches the color regs */
/*    vq_color(vdi_handle,         0,1,vdi_color[0]);
    vq_color(vdi_handle,         1,1,vdi_color[1]);
    vq_color(vdi_handle,trn_col[0],1,vdi_color[2]);
    vq_color(vdi_handle,trn_col[2],1,vdi_color[3]);
    col[0]=col[1]=col[2]=1000;
    vs_color(vdi_handle,         0,col);
    col[0]=col[1]=col[2]=333;
    vs_color(vdi_handle,         1,col);
    col[0]=col[1]=col[2]=667;
    vs_color(vdi_handle,trn_col[0],col);
    col[0]=col[1]=col[2]=0;
    vs_color(vdi_handle,trn_col[2],col);
*/
    trn_data=malloc((size_t)work_out[4]*SCR_HEIGHT*SCR_WIDTH/8);
    if (trn_data==NULL) {
      scr_close(handle);
      return -8;		/* can't get transfer buffer */
    }

    img_mfdb.fd_addr=trn_data;
    img_mfdb.fd_stand=0;
    img_mfdb.fd_nplanes=work_out[4];
    vrt_cpyfm(vdi_handle,MD_REPLACE,
              trn_pxy,&trn_mfdb[0],&img_mfdb,trn_col);
    vrt_cpyfm(vdi_handle,MD_XOR,
              trn_pxy,&trn_mfdb[1],&img_mfdb,trn_col);
              /* trn_col is dummy */
  }

  return handle;		/* everything's OK */
}

void scr_close(int handle) {
  /*----------------------*/
  int  x,y,w,h;

  if (scr_double<0) {
    vs_color(vdi_handle,         0,vdi_color[0]);
    vs_color(vdi_handle,         1,vdi_color[1]);
    vs_color(vdi_handle,trn_col[0],vdi_color[2]);
    vs_color(vdi_handle,trn_col[2],vdi_color[3]);

    if (trn_data!=NULL)
      free(trn_data);
  }

  wind_get(handle,WF_CURRXYWH,&x,&y,&w,&h);
  graf_shrinkbox(0,0,0,0,x,y,w,h);
  wind_close(handle);
  wind_delete(handle);
}

void scr_showgray(int handle,int mx,int my) {
  /*---------------------------------------*/
  int   qxy[400],*qi;
  int   nom;

  nom=mx>scr_pxy[4]-16 && mx<scr_pxy[6]+16 &&
      my>scr_pxy[5]-16 && my<scr_pxy[7]+16;

  qi=qxy;
  wind_get(handle,WF_FIRSTXYWH,qi+0,qi+1,qi+2,qi+3);
  while (qi[2]!=0 && qi[3]!=0) {
    if (qi==qxy+400-4)
      break;
    qi[2]+=qi[0]-1;
    qi[3]+=qi[1]-1;
    qi+=4;
    wind_get(handle,WF_NEXTXYWH,qi+0,qi+1,qi+2,qi+3);
  }
  qi[2]=0;

  if (scr_double>=0) {
    img_mfdb.fd_addr=*scr_img++;
    if (*scr_img==NULL)
      scr_img-=3;

    Vsync();
  }

  if (nom)
    graf_mouse(M_OFF,NULL);
  for (qi=qxy; qi[2]!=0; qi+=4) {
    vs_clip(vdi_handle,1,qi);
    vro_cpyfm(vdi_handle,S_ONLY,scr_pxy,&img_mfdb,&scr_mfdb);
  }
  if (nom)
    graf_mouse(M_ON,NULL);
}

void scr_auto_on(int handle) {
  /*------------------------*/
  char  *s;
  int   top;
  void  *usp;

  rsrc_gaddr(R_STRING,SSCRRUN,&s);
  wind_set(handle,WF_INFO,s);
  wind_set(handle,WF_TOP);
  wind_get(handle,WF_TOP,&top);
  if (top!=handle)
    return;			/* can't top window */

  vs_clip(vdi_handle,1,scr_pxy+4);

  if (scr_double>=0) {
    Vsync();
    scr_base=(char*)Logbase()+scr_pxy[5]*scr_bpl+scr_pxy[4]/8;
    usp=(void*)Super(0);
    old_vsync=*vbl_slot;
    *vbl_slot=my_vsync;
    Super(usp);
  }
}

void scr_auto_off(int handle) {
  /*-------------------------*/
  char  *s;
  void  *usp;

  rsrc_gaddr(R_STRING,SSCRSTOP,&s);
  wind_set(handle,WF_INFO,s);

  if (scr_double>=0) {
    usp=(void*)Super(0);
    *vbl_slot=old_vsync;
    Super(usp);
  }
}

void scr_gb2st(void) {
  /*----------------*/
  vrt_cpyfm(vdi_handle,MD_REPLACE,
            trn_pxy,&trn_mfdb[0],&img_mfdb,trn_col);
  vrt_cpyfm(vdi_handle,MD_XOR,
            trn_pxy,&trn_mfdb[1],&img_mfdb,trn_col);
            /* trn_col is dummy */
  vro_cpyfm(vdi_handle,S_ONLY,scr_pxy,&img_mfdb,&scr_mfdb);
}

void scr_moved(int handle,int x,int y) {
  /*----------------------------------*/
  int  sx,sy,sw,sh;
  int  w,h;

  wind_get(0,WF_WORKXYWH,&sx,&sy,&sw,&sh);
  wind_calc(WC_WORK,KIND,x,y,sw,sh,&x,&y,&w,&h);
  if (x<sx)
    x=sx;
  else if (x+SCR_WIDTH>sx+sw)
    x=sx+sw-SCR_WIDTH;
  x=((x/8+1)/2)*16;
  if (y<sy)
    y=sy;
  else if (y+SCR_HEIGHT>sy+sh)
    y=sy+sh-SCR_HEIGHT;
  wind_calc(WC_BORDER,KIND,x,y,SCR_WIDTH,SCR_HEIGHT,&x,&y,&w,&h);
  wind_set(handle,WF_CURRXYWH,x,y,w,h);
  wind_get(handle,WF_WORKXYWH,&x,&y,&w,&h);
  scr_pxy[4]=x;
  scr_pxy[5]=y;
  scr_pxy[6]=x+SCR_WIDTH-1;
  scr_pxy[7]=y+SCR_HEIGHT-1;
}

/* === End ====================================================	*/
